#============================================================================== 
# ** Ruby.Array.find
#------------------------------------------------------------------------------
# Description:
# ------------
# Methods created for finding and returning objects inside of an array.
#  
# Method List:
# ------------
# all_indexes
# find_index
# includes?
# includes_any?
# include_times
# of_index
#==============================================================================

MACL::Loaded << 'Ruby.Array.find'

#============================================================================== 
# ** Array     
#==============================================================================

class Array
  #-------------------------------------------------------------------------
  # * Name      : All Indexes 
  #   Info      : Returns All indexes where obj is (see find_index)
  #   Author    : Trickster
  #   Call Info : One Argument. Value (Object)
  #   Comment   : Synonym for find_index
  #-------------------------------------------------------------------------
  def all_indexes(obj)
    # Setup Array
    array = []
    # Run Through Push index if objects are equal
    each_index {|index| array << index if obj == self[index]}
    # Return Array
    return array
  end
  #-------------------------------------------------------------------------
  # * Name      : Finds Index 
  #   Info      : Finds all indexes with the value sent to it
  #   Author    : Trickster
  #   Call Info : One Argument. a Object
  #-------------------------------------------------------------------------
  def find_index(value)
    # Setup Array of Indexes
    indexes = []
    # Run Through each with index and add index if the same
    each_with_index {|element, index| indexes << index if element == value}
    # Return Indexes
    return indexes
  end  
  #-------------------------------------------------------------------------
  #   Name      : Includes?
  #   Info      : Returns true if all of the values sent is included
  #   Author    : Trickster
  #   Call Info : Variable Amount, Objects
  #   Comment   : If using an array and want to check each element, 
  #               use argument expansion to expand the array.
  #-------------------------------------------------------------------------
  def includes?(*args)
    # Return false if object is not included
    args.each {|object| return false unless include?(object)}
    # Everything is included
    return true
  end
  #-------------------------------------------------------------------------
  #   Name      : Includes Any?
  #   Info      : Returns true if any of the values sent is included
  #   Author    : Trickster
  #   Call Info : Variable Amount, Objects
  #   Comment   : If using an array and want to check each element, 
  #               use argument expansion to expand the array.
  #-------------------------------------------------------------------------
  def includes_any?(*args)
    # Return true if args is empty
    return true if args.empty?
    # Return true if any of the objects is included
    args.each {|object| return true if include?(object)}
    # Not Included
    return false
  end
  #-------------------------------------------------------------------------
  # * Name      : Include Times 
  #   Info      : Returns how many times the value sent is included
  #   Author    : Trickster
  #   Call Info : One Argument. anObject
  #-------------------------------------------------------------------------
  def include_times(obj)
    # Setup Local Variable
    times = 0
    # Run Through Each Increaing Times if object is equal
    each {|element| times += 1 if element == obj}
    # Return number of times included
    return times
  end
  #-------------------------------------------------------------------------
  # * Name      : Of index
  #   Info      : Assuming Self is an Array of Arrays returns the values at index
  #   Author    : Trickster
  #   Call Info : One - Integer index index of the values you want to return
  #-------------------------------------------------------------------------
  def of_index(index)
    # Create Array
    array = []
    # Run Through and get array at index
    each {|sub_array| array << sub_array[index] if sub_array.is_a?(Array)}
    # Return Array
    return array
  end
end